<?php
include("database.php");

$db = $conn;
$tableName = "tbl_contact";
$columns = ['tbl_contact_id', 'project', 'job_no', 'full_name', 'email', 'quality', 'message', 'code_confirmation'];
$fetchData = fetch_data($db, $tableName, $columns);

function fetch_data($db, $tableName, $columns)
{
    $msg = '';

    if (empty($db)) {
        $msg = "Database connection error";
    } elseif (empty($columns) || !is_array($columns)) {
        $msg = "Columns must be defined in an indexed array";
    } elseif (empty($tableName)) {
        $msg = "Table name is empty";
    } else {
        $columnName = implode(", ", $columns);
        $query = "SELECT $columnName FROM $tableName ORDER BY id DESC";
        $result = $db->query($query);

        if ($result) {
            if ($result->num_rows > 0) {
                $row = $result->fetch_all(MYSQLI_ASSOC);
                $msg = $row;
            } else {
                $msg = "No data found";
            }
        } else {
            $msg = $db->error;
        }
    }

    return $msg;
}
?>
